package com.onyx.test;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
Configuration information for a TestNG class:

@BeforeSuite: The annotated method will be run before all tests in this suite have run.
@AfterSuite: The annotated method will be run after all tests in this suite have run.
@BeforeTest: The annotated method will be run before the test.
@AfterTest: The annotated method will be run after the test.
@BeforeGroups: The list of groups that this configuration method will run before. This method is guaranteed to run shortly before the first test method that belongs to any of these groups is invoked.
@AfterGroups: The list of groups that this configuration method will run after. This method is guaranteed to run shortly after the last test method that belongs to any of these groups is invoked.
@BeforeClass: The annotated method will be run before all the tests in the test class have been run.
@AfterClass: The annotated method will be run after all the tests in the test class have been run.
@BeforeMethod: The annotated method will be run before any test method is invoked.
@AfterMethod: The annotated method will be run after any test method is invoked.

@Parameters	Describes how to pass parameters to a @Test method.
	value 	The list of variables used to fill the parameters of this method.
 
@Test	Marks a class or a method as part of the test.
	alwaysRun 	If set to true, this test method will always be run even if it depends on a method that failed.
	dataProvider 	The name of the data provider for this test method.
	dataProviderClass 	The class where to look for the data provider. If not specified, the data provider will be looked on the class of the current test method or one of its base classes. If this attribute is specified, the data provider method needs to be static on the specified class.
	dependsOnGroups 	The list of groups this method depends on.
	dependsOnMethods 	The list of methods this method depends on.
	description 	The description for this method.
	enabled 	Whether methods on this class/method are enabled.
	expectedExceptions 	The list of exceptions that a test method is expected to throw. If no exception or a different than one on this list is thrown, this test will be marked a failure.
	groups 	The list of groups this class/method belongs to.
	invocationCount 	The number of times this method should be invoked.
	successPercentage 	The percentage of success expected from this method
	sequential 	If set to true, all the methods on this test class are guaranteed to run sequentially, even if the tests are currently being run with parallel="true". This attribute can only be used at the class level and it will be ignored if used at the method level.
	timeOut 	The maximum number of milliseconds this test should take.
	threadPoolSize 	The size of the thread pool for this method. The method will be invoked from multiple threads as specified by invocationCount.
Note: this attribute is ignored if invocationCount is not specified
 * 
 *
 */
public class NGTestExample {	

	  @BeforeClass(groups = { "Global" })
	  public void setUp() {
	    // code that will be invoked when this test is instantiated
	  }

	  @Test(groups = { "Global" })	  
	  public void method() {	    
	    assert "Test".equals("Test") : "Expected Test";
	  }

	  @Test(groups = { "Global" })
	  public void aSlowTest() {
	     System.out.println("Slow test");
	  }
	  
	  @DataProvider(name = "dp")
	  public Object[][] createData() {
	   return new Object[][] {{ "Test1"},{ "Test2"},{ "Test3"}};
	  }

	  
	  @Test(groups = { "Global" },dataProvider = "dp")	 
	  public void Hello(String hell){
		  System.out.println(hell);
	  }

}
