package com.onyx.hello;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.naming.NamingException;

/**
 * 
 * @author Ferdinand Dosser
 * Last Update: 02 Aug 2007
 *
 */
public class HelloWorld {
	
	protected static Logger logger  = Logger.getLogger(HelloWorld.class.getName());
	
	protected String worldMsg 	= null;
	
	/**
	 * Creates a new HelloWorld.
	 */
	public HelloWorld(){ 
		logger.log(Level.INFO,"Creating the HelloWorld plugin");
		this.worldMsg = "World";		
	}
	
	
	/**
	 * Called by the parent module to load this module or one of his children.
	 * A module is responsible for his loading and his children's loading.
	 * @param prop the properties attached to the module to load
	 */
	public void load(Properties prop){
		logger.log(Level.INFO,"Loading the module ["+prop.getProperty("id")+"]");
		//Display Hello World
		System.out.println("Hello "+worldMsg);
	}
	
	
	public String getWorldMsg(){
		return this.worldMsg;
	}
	
	public void setWorldMsg(String newWorldMsg){
		this.worldMsg=newWorldMsg;
	}
	
	/**
	 * Called by the parent module to unload this module or one of his children.
	 * A module is responsible for his unloading and his children's unloading.
	 * @param prop the properties attached to the module to unload
	 */
	public void unload(Properties prop){
		logger.log(Level.INFO,"UnLoading the module ["+prop.getProperty("id")+"]");
		//Display Bye Bye World
		System.out.println("Bye Bye "+worldMsg);
	}
}
