/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.TestNGException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T> {
    private static boolean m_verbose = false;
    private Map<T, Node<T>> m_nodes = new HashMap<T, Node<T>>();
    private List<T> m_strictlySortedNodes = null;
    private Map<T, Node<T>> m_independentNodes = null;

    public void addNode(T tm) {
        Graph.ppp("ADDING NODE " + tm + " " + tm.hashCode());
        this.m_nodes.put(tm, new Node<T>(tm));
    }

    public boolean isIndependent(T object) {
        return this.m_independentNodes.containsKey(object);
    }

    private Node<T> findNode(T object) {
        return this.m_nodes.get(object);
    }

    public void addPredecessor(T tm, T predecessor) {
        Graph.ppp("ADDING PREDECESSOR(" + tm + ") = " + predecessor);
        Node<T> node = this.findNode(tm);
        if (null == node) {
            throw new TestNGException("Non-existing node: " + tm);
        }
        node.addPredecessor(predecessor);
        if (null == this.m_independentNodes) {
            this.m_independentNodes = new HashMap<T, Node<T>>();
            for (T k : this.m_nodes.keySet()) {
                this.m_independentNodes.put(k, this.m_nodes.get(k));
            }
        }
        this.m_independentNodes.remove(predecessor);
        this.m_independentNodes.remove(tm);
        Graph.ppp("  REMOVED " + predecessor + " FROM INDEPENDENT OBJECTS");
    }

    private Collection<Node<T>> getNodes() {
        return this.m_nodes.values();
    }

    public Set<T> getIndependentNodes() {
        return this.m_independentNodes.keySet();
    }

    public List<T> getStrictlySortedNodes() {
        return this.m_strictlySortedNodes;
    }

    public void topologicalSort() {
        Graph.ppp("================ SORTING");
        this.m_strictlySortedNodes = new ArrayList<T>();
        if (null == this.m_independentNodes) {
            this.m_independentNodes = new HashMap<T, Node<T>>();
        }
        ArrayList<Node<T>> nodes2 = new ArrayList<Node<T>>();
        for (Node<T> n : this.getNodes()) {
            if (!this.isIndependent(n.getObject())) {
                Graph.ppp("ADDING FOR SORT: " + n.getObject());
                nodes2.add((Node<T>)n.clone());
                continue;
            }
            Graph.ppp("SKIPPING INDEPENDENT NODE " + n);
        }
        while (!nodes2.isEmpty()) {
            Node<T> node = this.findNodeWithNoPredecessors(nodes2);
            if (null == node) {
                throw new TestNGException("Cyclic graph of methods");
            }
            this.m_strictlySortedNodes.add(node.getObject());
            this.removeFromNodes(nodes2, node);
        }
        Graph.ppp("=============== DONE SORTING");
        if (m_verbose) {
            this.dumpSortedNodes();
        }
    }

    private void dumpSortedNodes() {
        System.out.println("====== SORTED NODES");
        for (T n : this.m_strictlySortedNodes) {
            System.out.println("              " + n);
        }
        System.out.println("====== END SORTED NODES");
    }

    private void dumpGraph() {
        System.out.println("====== GRAPH");
        for (Node<T> n : this.m_nodes.values()) {
            System.out.println("  " + n);
        }
    }

    private void removeFromNodes(List<Node<T>> nodes, Node<T> node) {
        nodes.remove(node);
        for (Node<T> n : nodes) {
            n.removePredecessor(node.getObject());
        }
    }

    private static void ppp(String s) {
        if (m_verbose) {
            System.out.println("[Graph] " + s);
        }
    }

    private Node<T> findNodeWithNoPredecessors(List<Node<T>> nodes) {
        for (Node<T> n : nodes) {
            if (n.hasPredecessors()) continue;
            return n;
        }
        return null;
    }

    public List<T> findPredecessors(T o) {
        ArrayList<Object> result = new ArrayList<Object>();
        Node<T> node = this.findNode(o);
        if (null == node) {
            throw new AssertionError((Object)("No such node: " + o));
        }
        ArrayList<Node<T>> nodesToWalk = new ArrayList<Node<T>>();
        for (Node<T> node2 : this.getNodes()) {
            T obj = node2.getObject();
            if (!node.hasPredecessor(obj)) continue;
            Graph.ppp("FOUND PREDECESSOR " + node2);
            if (result.contains(obj)) continue;
            result.add(0, obj);
            nodesToWalk.add(node2);
        }
        for (Node<Object> node3 : nodesToWalk) {
            List<Object> r = this.findPredecessors(node3.getObject());
            for (Object obj : r) {
                if (result.contains(obj)) continue;
                result.add(0, obj);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Graph ");
        for (T node : this.m_nodes.keySet()) {
            result.append(this.findNode(node)).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public static void main(String[] argv) {
        Graph<String> g = new Graph<String>();
        g.addNode("3");
        g.addNode("1");
        g.addNode("2.2");
        g.addNode("independent");
        g.addNode("2.1");
        g.addNode("2");
        g.addPredecessor("3", "2");
        g.addPredecessor("3", "2.1");
        g.addPredecessor("3", "2.2");
        g.addPredecessor("2", "1");
        g.addPredecessor("2.1", "1");
        g.addPredecessor("2.2", "1");
        g.topologicalSort();
        List l = g.getStrictlySortedNodes();
        for (String s : l) {
            System.out.println("  " + s);
        }
        int i = 0;
        assert ("1".equals(l.get(i)));
        assert ("2".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)));
        assert ("2".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)));
        assert ("2".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)));
        assert ("3".equals(l.get(++i)));
        assert (1 == g.getIndependentNodes().size());
        Graph.ppp("GRAPH:" + g);
        List<String> predecessors = g.findPredecessors("2");
        assert (predecessors.size() == 1);
        assert (predecessors.get(0).equals("1"));
        predecessors = g.findPredecessors("3");
        assert (predecessors.size() == 4);
        assert (predecessors.get(0).equals("1"));
        assert (predecessors.get(1).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"));
        assert (predecessors.get(2).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"));
        assert (predecessors.get(3).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"));
        Graph.ppp("TESTS PASSED");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<T> {
        private T m_object = null;
        private Map<T, T> m_predecessors = new HashMap<T, T>();

        public Node(T tm) {
            this.m_object = tm;
        }

        public Node<T> clone() {
            Node<T> result = new Node<T>(this.m_object);
            for (T pred : this.m_predecessors.values()) {
                result.addPredecessor(pred);
            }
            return result;
        }

        public T getObject() {
            return this.m_object;
        }

        public Map<T, T> getPredecessors() {
            return this.m_predecessors;
        }

        public boolean removePredecessor(T o) {
            boolean result = false;
            T pred = this.m_predecessors.get(o);
            if (null != pred) {
                boolean bl = result = null != this.m_predecessors.remove(o);
                if (result) {
                    Graph.ppp("  REMOVED PRED " + o + " FROM NODE " + this.m_object);
                } else {
                    Graph.ppp("  FAILED TO REMOVE PRED " + o + " FROM NODE " + this.m_object);
                }
            }
            return result;
        }

        private void dump() {
            Graph.ppp(this.toString());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[Node:" + this.m_object);
            sb.append("  pred:");
            for (T o : this.m_predecessors.values()) {
                sb.append(" " + o.toString());
            }
            sb.append("]");
            String result = sb.toString();
            return result;
        }

        public void addPredecessor(T tm) {
            Graph.ppp("  ADDING PREDECESSOR " + this.m_object + " " + tm);
            this.m_predecessors.put(tm, tm);
        }

        public boolean hasPredecessors() {
            return this.m_predecessors.size() > 0;
        }

        public boolean hasPredecessor(T m) {
            return this.m_predecessors.containsKey(m);
        }
    }
}

