/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final String JDK5_ANNOTATIONFINDER_CLASS = "org.testng.internal.annotations.JDK15AnnotationFinder";

    private ClassHelper() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException("Class " + clazz.getName() + " does not have a no-args constructor", iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException("Cannot instantiate class " + clazz.getName(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException("An exception occurred in static initialization of class " + clazz.getName(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static Class<?> forName(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static Method findFactoryMethod(Class<?> cls, IAnnotationFinder finder) {
        Method result = null;
        for (Method method : cls.getDeclaredMethods()) {
            IAnnotation f = finder.findAnnotation(method, IFactory.class);
            if (null == f) continue;
            if (null != result) {
                throw new TestNGException(cls.getName() + ":  only one @Factory method allowed");
            }
            result = method;
        }
        return result;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        for (Class<?> parent = clazz.getSuperclass(); null != parent; parent = parent.getSuperclass()) {
            methods.addAll(ClassHelper.extractMethods(clazz, parent, methods));
        }
        return methods;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner runner) {
        try {
            IJUnitTestRunner tr = (IJUnitTestRunner)ClassHelper.forName(JUNIT_TESTRUNNER).newInstance();
            tr.setTestResultNotifier(runner);
            return tr;
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create JUnit runner org.testng.junit.JUnitTestRunner", ex);
        }
    }

    public static IAnnotationFinder createJdkAnnotationFinder(IAnnotationTransformer annoTransformer) {
        try {
            Class<?> clazz = ClassHelper.forName(JDK5_ANNOTATIONFINDER_CLASS);
            Constructor<?> ctor = clazz.getConstructor(IAnnotationTransformer.class);
            return (IAnnotationFinder)ctor.newInstance(annoTransformer);
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create/initialize the JDK5 annotation finder org.testng.internal.annotations.JDK15AnnotationFinder", ex);
        }
    }

    private static Set<Method> extractMethods(Class<?> childClass, Class<?> clazz, Set<Method> collected) {
        HashSet<Method> methods = new HashSet<Method>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        for (Method method : declaredMethods) {
            int methodModifiers = method.getModifiers();
            if (Modifier.isPublic(methodModifiers) || Modifier.isProtected(methodModifiers)) {
                if (ClassHelper.isOverridden(method, collected)) continue;
                methods.add(method);
                continue;
            }
            if (!isSamePackage || Modifier.isPrivate(methodModifiers) || ClassHelper.isOverridden(method, collected)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean isOverridden(Method method, Set<Method> collectedMethods) {
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!method.getName().equals(m.getName()) || !methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
        }
    }

    public static Object createInstance(Class<?> declaringClass, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, IObjectFactory objectFactory) {
        Object result;
        try {
            Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(finder, declaringClass);
            if (null != constructor) {
                IParameters annotation = (IParameters)finder.findAnnotation(constructor, IParameters.class);
                String[] parameterNames = annotation.getValue();
                Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", parameterNames, xmlTest.getParameters(), xmlTest.getSuite());
                result = objectFactory.newInstance(constructor, parameters);
            } else {
                boolean isStatic;
                Class[] parameterTypes = new Class[]{};
                Object[] parameters = new Object[]{};
                Class<?> ec = ClassHelper.getEnclosingClass(declaringClass);
                boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
                if (null != ec && !isStatic) {
                    Object[] enclosingInstances;
                    parameterTypes = new Class[]{ec};
                    IClass enclosingIClass = classes.get(ec);
                    if (null != enclosingIClass) {
                        enclosingInstances = enclosingIClass.getInstances(false);
                        if (null == enclosingInstances || enclosingInstances.length == 0) {
                            Object o = objectFactory.newInstance(ec.getConstructor(parameterTypes), new Object[0]);
                            enclosingIClass.addInstance(o);
                            enclosingInstances = new Object[]{o};
                        }
                    } else {
                        enclosingInstances = new Object[]{ec.newInstance()};
                    }
                    Object enclosingClassInstance = enclosingInstances[0];
                    parameters = new Object[]{enclosingClassInstance};
                }
                Constructor<?> ct = declaringClass.getDeclaredConstructor(parameterTypes);
                result = objectFactory.newInstance(ct, parameters);
            }
        }
        catch (TestNGException ex) {
            throw ex;
        }
        catch (NoSuchMethodException ex) {
            result = ClassHelper.tryOtherConstructor(declaringClass);
        }
        catch (Throwable cause) {
            throw new TestNGException("An error occured while instantiating class " + declaringClass.getName() + ": " + cause.getMessage(), cause);
        }
        return result;
    }

    private static Class<?> getEnclosingClass(Class<?> declaringClass) {
        Class<?> result = null;
        String className = declaringClass.getName();
        int index = className.indexOf("$");
        if (index != -1) {
            String ecn = className.substring(0, index);
            try {
                result = Class.forName(ecn);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Constructor<?> findAnnotatedConstructor(IAnnotationFinder finder, Class<?> declaringClass) {
        Constructor<?>[] constructors = declaringClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] parameterTypes;
            Constructor<?> result = constructors[i];
            IParameters annotation = (IParameters)finder.findAnnotation(result, IParameters.class);
            if (null == annotation) continue;
            String[] parameters = annotation.getValue();
            if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                throw new TestNGException("Parameter count mismatch:  " + result + "\naccepts " + parameterTypes.length + " parameters but the @Test annotation declares " + parameters.length);
            }
            return result;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> declaringClass) {
        T result;
        try {
            Constructor<T> ctor = declaringClass.getConstructor(String.class);
            result = ctor.newInstance("Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String error = "Could not create an instance of class " + declaringClass + (message != null ? ": " + message : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(error);
        }
        return result;
    }
}

